<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('articles', function(Blueprint $table) {
			$table->foreign('article_type_id')->references('id')->on('articles')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('course_type_id')->references('id')->on('course_types')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('course_detail', function(Blueprint $table) {
			$table->foreign('id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('unit_detail', function(Blueprint $table) {
			$table->foreign('id')->references('id')->on('units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('staff', function(Blueprint $table) {
			$table->foreign('staff_type_id')->references('id')->on('staff_types')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('staff_unit', function(Blueprint $table) {
			$table->foreign('staff_id')->references('id')->on('staff')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('staff_unit', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('course_unit', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('course_unit', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('course_unit', function(Blueprint $table) {
			$table->foreign('year_id')->references('id')->on('course_years')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('course_unit', function(Blueprint $table) {
			$table->foreign('schedule_id')->references('id')->on('unit_schedules')
						->onDelete('set null')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('articles', function(Blueprint $table) {
			$table->dropForeign('articles_article_type_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_course_type_id_foreign');
		});
		Schema::table('course_detail', function(Blueprint $table) {
			$table->dropForeign('course_detail_id_foreign');
		});
		Schema::table('unit_detail', function(Blueprint $table) {
			$table->dropForeign('unit_detail_id_foreign');
		});
		Schema::table('staff', function(Blueprint $table) {
			$table->dropForeign('staff_staff_type_id_foreign');
		});
		Schema::table('staff_unit', function(Blueprint $table) {
			$table->dropForeign('staff_unit_staff_id_foreign');
		});
		Schema::table('staff_unit', function(Blueprint $table) {
			$table->dropForeign('staff_unit_unit_id_foreign');
		});
		Schema::table('course_unit', function(Blueprint $table) {
			$table->dropForeign('course_unit_course_id_foreign');
		});
		Schema::table('course_unit', function(Blueprint $table) {
			$table->dropForeign('course_unit_unit_id_foreign');
		});
		Schema::table('course_unit', function(Blueprint $table) {
			$table->dropForeign('course_unit_year_id_foreign');
		});
		Schema::table('course_unit', function(Blueprint $table) {
			$table->dropForeign('course_unit_schedule_id_foreign');
		});
	}
}