<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticleTypesTable extends Migration {

	public function up()
	{
		Schema::create('article_types', function(Blueprint $table) {
			$table->increments('id');
			$table->string('slug')->unique();
			$table->string('name');
			$table->string('image')->nullable();
			$table->tinyInteger('active')->default('1');
			$table->integer('order')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('article_types');
	}
}