<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStaffTable extends Migration {

	public function up()
	{
		Schema::create('staff', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('staff_type_id')->unsigned()->nullable();
			$table->string('name');
			$table->string('phone')->nullable();
			$table->string('phone_extension')->nullable();
			$table->string('email')->nullable();
			$table->string('url')->nullable();
			$table->string('image')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('staff');
	}
}