<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Article extends Eloquent {

	protected $table = 'articles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('article_type_id', 'title', 'subtitle', 'slug', 'short', 'text', 'thumb', 'image', 'date', 'highlight', 'status', 'order');
	protected $visible = array('article_type_id', 'title', 'subtitle', 'slug', 'short', 'text', 'thumb', 'image', 'date', 'highlight', 'status', 'order');

	public function type()
	{
		return $this->belongsTo('ArticleType');
	}

}