<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Unit extends Eloquent {

	protected $table = 'units';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('code', 'acronym');
	protected $visible = array('code', 'acronym');

	public function staff()
	{
		return $this->belongsToMany('Staff');
	}

	public function detais()
	{
		return $this->hasMany('UnitDetail');
	}

	public function Course()
	{
		return $this->belongsToMany('Course')->withPivot('year_id', 'schedule_id', 'credits_ects');
	}

}