<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InventoryRecordItem extends Model 
{

    protected $table = 'inventory_record_item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('record_id', 'item_id', 'quantity', 'type', 'notes');

    public function record()
    {
        return $this->belongsTo('InventoryRecord', 'record_id');
    }

    public function item()
    {
        return $this->belongsTo('InventoryItem', 'item_id');
    }

}