<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AchievementValue extends Model 
{

    protected $table = 'achievement_value';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('item_id', 'percentage', 'notes', 'achievement_id');

    public function achievement()
    {
        return $this->belongsTo('AchievementCertificate', 'achievement_id');
    }

    public function item()
    {
        return $this->belongsTo('AchievementItem', 'item_id');
    }

}