<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InventoryHistory extends Model 
{

    protected $table = 'inventory_history';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('inventory_id', 'item_id', 'quantity', 'notes', 'type', 'process_type', 'date');

    public function inventory()
    {
        return $this->belongsTo('Inventory', 'inventory_id');
    }

    public function item()
    {
        return $this->belongsTo('InventoryItem', 'item_id');
    }

}