<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PeriodicItem extends Model 
{

    protected $table = 'periodic_item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('periodic_id', 'item_id', 'progress', 'notes');

    public function item()
    {
        return $this->belongsTo('PeriodicItemData', 'item_id');
    }

    public function periodic()
    {
        return $this->belongsTo('PeriodicMaintenance', 'periodic_id');
    }

}