<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Region extends Model 
{

    protected $table = 'region';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'officer_id', 'employee_id');

    public function employee()
    {
        return $this->belongsTo('User', 'employee_id');
    }

    public function officer()
    {
        return $this->belongsTo('User', 'officer_id');
    }

}