<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabOrderDetailsTable extends Migration {

	public function up()
	{
		Schema::create('tabOrderDetails', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->integer('product_id');
			$table->integer('web_product_id');
			$table->integer('variant_id')->nullable();
			$table->integer('customization_id')->nullable();
			$table->decimal('rate', 10,2);
			$table->integer('qty');
			$table->decimal('amount', 10,2);
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('tabOrderDetails');
	}
}