<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabOrderTaxDetailsTable extends Migration {

	public function up()
	{
		Schema::create('tabOrderTaxDetails', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->string('name');
			$table->string('tax_type');
			$table->decimal('rate', 10,2);
			$table->decimal('amount', 10,2);
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('tabOrderTaxDetails');
	}
}