<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabOrderTable extends Migration {

	public function up()
	{
		Schema::create('tabOrder', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('seller_id')->unsigned();
			$table->string('order_no')->nullable();
			$table->timestamp('order_date');
			$table->string('order_status');
			$table->string('buyer_contact_no');
			$table->integer('buyer_id');
			$table->string('buyer_name');
			$table->text('delivery_address');
			$table->decimal('sub_total', 10,2);
			$table->decimal('tax_total', 10,2);
			$table->decimal('delivery_charges', 10,2);
			$table->string('coupon')->nullable();
			$table->string('discount_type')->nullable();
			$table->decimal('discount_value', 10,2)->nullable();
			$table->decimal('discount_amount', 10,2)->nullable();
			$table->decimal('grand_total', 10,2);
			$table->decimal('rounded_total', 10,2);
			$table->string('mode_of_payment');
			$table->text('description')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('tabOrder');
	}
}