<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabPostCodeTable extends Migration {

	public function up()
	{
		Schema::create('tabPostCode', function(Blueprint $table) {
			$table->increments('id');
			$table->string('post_code');
			$table->string('latitude')->nullable();
			$table->string('longitude')->nullable();
			$table->string('city')->nullable();
			$table->string('state')->nullable();
			$table->string('country')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('tabPostCode');
	}
}