<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabDeliveryAreaDetailsTable extends Migration {

	public function up()
	{
		Schema::create('tabDeliveryAreaDetails', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('delivery_area_id')->unsigned();
			$table->string('post_code');
			$table->decimal('minimum_order', 10,2);
			$table->decimal('delivery_charges', 10,2);
			$table->time('delivery_time');
			$table->decimal('express_delivery_charges', 10,2);
			$table->time('express_delivery_time');
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('tabDeliveryAreaDetails');
	}
}