<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabRecipeTable extends Migration {

	public function up()
	{
		Schema::create('tabRecipe', function(Blueprint $table) {
			$table->increments('id');
			$table->string('avatar')->nullable();
			$table->string('status')->default('Active');
			$table->string('title');
			$table->text('description');
			$table->time('preparation_time')->nullable();
			$table->integer('no_of_servings')->nullable();
			$table->string('slug');
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
			$table->integer('seller_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('tabRecipe');
	}
}