<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabRegionTable extends Migration {

	public function up()
	{
		Schema::create('tabRegion', function(Blueprint $table) {
			$table->increments('id');
			$table->text('avatar')->nullable();
			$table->string('name');
			$table->string('title')->nullable();
			$table->text('description')->nullable();
			$table->string('status')->default('Active');
			$table->boolean('show_on_carousel')->default(0);
			$table->boolean('show_on_navbar')->default(0);
			$table->string('slug');
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('tabRegion');
	}
}