<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tabFaq', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('tabFaqCategory')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabOrder', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('tabSeller')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabOrderTaxDetails', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('tabOrder')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabOrderDetails', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('tabOrder')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabOrderStatus', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('tabOrder')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabRecipe', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('tabSeller')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabRecipeProduct', function(Blueprint $table) {
			$table->foreign('recipe_id')->references('id')->on('tabRecipe')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabBuyerAddress', function(Blueprint $table) {
			$table->foreign('buyer_id')->references('id')->on('tabBuyer')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabProduct', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('tabSeller')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabProduct', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('tabRegion')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('tabProduct', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('tabCategory')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabProduct', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('tabUnit')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabProductComboDetails', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('tabProduct')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabProductComboDetails', function(Blueprint $table) {
			$table->foreign('combo_product_id')->references('id')->on('tabProduct')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabProductCustomizationDetails', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('tabProduct')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabProductVariantDetails', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('tabProduct')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabProductVariantDetails', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('tabUnit')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabCoupon', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('tabSeller')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabDeliveryArea', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('tabSeller')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabDeliveryAreaDetails', function(Blueprint $table) {
			$table->foreign('delivery_area_id')->references('id')->on('tabDeliveryArea')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabSellerWorkingDays', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('tabSeller')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabSellerHolidays', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('tabSeller')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabSellerPickLocations', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('tabSeller')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabBuyerFavorites', function(Blueprint $table) {
			$table->foreign('buyer_id')->references('id')->on('tabBuyer')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabBuyerFavorites', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('tabProduct')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabProductRelated', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('tabProduct')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabProductRelated', function(Blueprint $table) {
			$table->foreign('related_product_id')->references('id')->on('tabProduct')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabProductComments', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('tabProduct')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabProductImages', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('tabProduct')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('tabFaq', function(Blueprint $table) {
			$table->dropForeign('tabFaq_category_id_foreign');
		});
		Schema::table('tabOrder', function(Blueprint $table) {
			$table->dropForeign('tabOrder_seller_id_foreign');
		});
		Schema::table('tabOrderTaxDetails', function(Blueprint $table) {
			$table->dropForeign('tabOrderTaxDetails_order_id_foreign');
		});
		Schema::table('tabOrderDetails', function(Blueprint $table) {
			$table->dropForeign('tabOrderDetails_order_id_foreign');
		});
		Schema::table('tabOrderStatus', function(Blueprint $table) {
			$table->dropForeign('tabOrderStatus_order_id_foreign');
		});
		Schema::table('tabRecipe', function(Blueprint $table) {
			$table->dropForeign('tabRecipe_seller_id_foreign');
		});
		Schema::table('tabRecipeProduct', function(Blueprint $table) {
			$table->dropForeign('tabRecipeProduct_recipe_id_foreign');
		});
		Schema::table('tabBuyerAddress', function(Blueprint $table) {
			$table->dropForeign('tabBuyerAddress_buyer_id_foreign');
		});
		Schema::table('tabProduct', function(Blueprint $table) {
			$table->dropForeign('tabProduct_seller_id_foreign');
		});
		Schema::table('tabProduct', function(Blueprint $table) {
			$table->dropForeign('tabProduct_region_id_foreign');
		});
		Schema::table('tabProduct', function(Blueprint $table) {
			$table->dropForeign('tabProduct_category_id_foreign');
		});
		Schema::table('tabProduct', function(Blueprint $table) {
			$table->dropForeign('tabProduct_unit_id_foreign');
		});
		Schema::table('tabProductComboDetails', function(Blueprint $table) {
			$table->dropForeign('tabProductComboDetails_product_id_foreign');
		});
		Schema::table('tabProductComboDetails', function(Blueprint $table) {
			$table->dropForeign('tabProductComboDetails_combo_product_id_foreign');
		});
		Schema::table('tabProductCustomizationDetails', function(Blueprint $table) {
			$table->dropForeign('tabProductCustomizationDetails_product_id_foreign');
		});
		Schema::table('tabProductVariantDetails', function(Blueprint $table) {
			$table->dropForeign('tabProductVariantDetails_product_id_foreign');
		});
		Schema::table('tabProductVariantDetails', function(Blueprint $table) {
			$table->dropForeign('tabProductVariantDetails_unit_id_foreign');
		});
		Schema::table('tabCoupon', function(Blueprint $table) {
			$table->dropForeign('tabCoupon_seller_id_foreign');
		});
		Schema::table('tabDeliveryArea', function(Blueprint $table) {
			$table->dropForeign('tabDeliveryArea_seller_id_foreign');
		});
		Schema::table('tabDeliveryAreaDetails', function(Blueprint $table) {
			$table->dropForeign('tabDeliveryAreaDetails_delivery_area_id_foreign');
		});
		Schema::table('tabSellerWorkingDays', function(Blueprint $table) {
			$table->dropForeign('tabSellerWorkingDays_seller_id_foreign');
		});
		Schema::table('tabSellerHolidays', function(Blueprint $table) {
			$table->dropForeign('tabSellerHolidays_seller_id_foreign');
		});
		Schema::table('tabSellerPickLocations', function(Blueprint $table) {
			$table->dropForeign('tabSellerPickLocations_seller_id_foreign');
		});
		Schema::table('tabBuyerFavorites', function(Blueprint $table) {
			$table->dropForeign('tabBuyerFavorites_buyer_id_foreign');
		});
		Schema::table('tabBuyerFavorites', function(Blueprint $table) {
			$table->dropForeign('tabBuyerFavorites_product_id_foreign');
		});
		Schema::table('tabProductRelated', function(Blueprint $table) {
			$table->dropForeign('tabProductRelated_product_id_foreign');
		});
		Schema::table('tabProductRelated', function(Blueprint $table) {
			$table->dropForeign('tabProductRelated_related_product_id_foreign');
		});
		Schema::table('tabProductComments', function(Blueprint $table) {
			$table->dropForeign('tabProductComments_product_id_foreign');
		});
		Schema::table('tabProductImages', function(Blueprint $table) {
			$table->dropForeign('tabProductImages_product_id_foreign');
		});
	}
}