<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFaqsTable extends Migration {

	public function up()
	{
		Schema::create('faqs', function(Blueprint $table) {
			$table->increments('id');
			$table->text('question');
			$table->longText('answer');
			$table->integer('faq_category_id');
			$table->boolean('status')->default(1);
			$table->bigInteger('created_by')->unsigned();
			$table->bigInteger('modified_by')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('faqs');
	}
}