<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100);
			$table->string('email', 1000);
			$table->string('password', 1000);
			$table->string('mobile', 100);
			$table->string('gender', 10);
			$table->date('dob');
			$table->text('address');
			$table->string('city', 100);
			$table->string('state', 100);
			$table->string('pincode', 10);
			$table->string('country', 100);
			$table->string('user_type', 10);
			$table->boolean('status')->default(1);
			$table->integer('created_by');
			$table->integer('modified_by');
			$table->rememberToken('remember_token');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}