<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNgoTable extends Migration {

	public function up()
	{
		Schema::create('ngo', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('name', 1000);
			$table->string('logo', 100);
			$table->longText('desc');
			$table->boolean('status');
			$table->integer('created_by');
			$table->integer('modified_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('ngo');
	}
}