<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserDonationTable extends Migration {

	public function up()
	{
		Schema::create('user_donation', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('campaign_id')->unsigned();
			$table->bigInteger('ngo_id')->unsigned();
			$table->string('donation_type', 100);
			$table->float('amount');
			$table->string('type', 100);
			$table->string('education', 1000);
			$table->string('skill', 1000);
			$table->string('avl_day', 100);
			$table->string('avl_time', 100);
			$table->date('start_date');
			$table->string('cover_letter', 1000);
			$table->string('facebook', 1000);
			$table->string('twitter', 1000);
			$table->string('linkedin', 1000);
			$table->bigInteger('campaign_inkind_id')->unsigned();
			$table->string('payment_status', 10);
			$table->string('transaction_id', 100);
			$table->string('payment_mode', 100);
			$table->string('card_no', 100);
			$table->string('payment_frequency', 10);
			$table->integer('created_by')->unsigned();
			$table->integer('modified_by')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_donation');
	}
}