<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProdutosTable extends Migration {

	public function up()
	{
		Schema::create('produtos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('categoriasprodutos_id')->unsigned();
			$table->integer('tiposeventos_id')->unsigned()->nullable();
			$table->string('nome', 254);
			$table->float('valor');
			$table->integer('cotas')->nullable();
			$table->string('ativo', 1);
			$table->string('extras', 1);
		});
	}

	public function down()
	{
		Schema::drop('produtos');
	}
}