<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMealsTable extends Migration {

	public function up()
	{
		Schema::create('meals', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid', 64);
			$table->integer('meal_type_id');
			$table->string('name', 64);
			$table->decimal('preparation_time');
			$table->decimal('labour');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('meals');
	}
}