<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Meal extends Model 
{

    protected $table = 'meals';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function recipes()
    {
        return $this->belongsToMany('Recipe');
    }

    public function ingredients()
    {
        return $this->belongsToMany('Ingredient');
    }

}