<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMomentsTable extends Migration {

	public function up()
	{
		Schema::create('moments', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid', 64);
			$table->integer('type_id');
			$table->integer('event_id');
			$table->string('name', 255);
			$table->datetime('start_datetime');
			$table->datetime('end_datetime');
			$table->integer('order');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('moments');
	}
}