<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIngredientsTable extends Migration {

	public function up()
	{
		Schema::create('ingredients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid', 64);
			$table->integer('category_id');
			$table->integer('unit_id');
			$table->string('name', 64);
			$table->string('code', 255);
			$table->float('stock');
			$table->float('max_stock');
			$table->float('min_stock');
			$table->integer('output');
			$table->integer('order');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('ingredients');
	}
}