<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Moment extends Eloquent {

	protected $table = 'moments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function meals()
	{
		return $this->belongsToMany('MealMoment')->withPivot('id', 'quantity');
	}

	public function drinks()
	{
		return $this->belongsToMany('DrinkMoment')->withPivot('id', 'quantity');
	}

}