<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function category()
	{
		return $this->hasOne('Category');
	}

	public function user()
	{
		return $this->hasOne('User');
	}

	public function customer()
	{
		return $this->hasOne('Customer');
	}

	public function stock()
	{
		return $this->hasOne('Stock');
	}

	public function barcodes()
	{
		return $this->hasMany('ProductBarcodes');
	}

}