<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class StockTransactions extends Eloquent {

	protected $table = 'stock_transactions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function moveType()
	{
		return $this->hasOne('MovwTypes');
	}

	public function differences()
	{
		return $this->hasMany('StockTransactionDiffrences');
	}

	public function stockMovements()
	{
		return $this->hasMany('StockMovement');
	}

	public function warehouse()
	{
		return $this->hasOne('Warehouse');
	}

	public function order()
	{
		return $this->hasOne('Orders');
	}

}