<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('rf_communities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_communities', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_communities', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('districts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rf_communities', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rf_buildings', function(Blueprint $table) {
			$table->foreign('rf_community_id')->references('id')->on('rf_communities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_units', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('rf_specifications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_units', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('rf_specifications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_units', function(Blueprint $table) {
			$table->foreign('rf_community_id')->references('id')->on('rf_communities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_units', function(Blueprint $table) {
			$table->foreign('rf_building_id')->references('id')->on('rf_buildings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_specifications', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('rf_specifications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_unit_areas', function(Blueprint $table) {
			$table->foreign('rf_unit_id')->references('id')->on('rf_units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_specification_unit', function(Blueprint $table) {
			$table->foreign('rf_unit_id')->references('id')->on('rf_units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_specification_unit', function(Blueprint $table) {
			$table->foreign('rf_specification_id')->references('id')->on('rf_specification_unit')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_unit_rooms', function(Blueprint $table) {
			$table->foreign('rf_unit_id')->references('id')->on('rf_units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_unit_marketplaces', function(Blueprint $table) {
			$table->foreign('rf_unit_id')->references('id')->on('rf_units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_leases', function(Blueprint $table) {
			$table->foreign('fit_out_status_id')->references('id')->on('rf_lease_specifications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_leases', function(Blueprint $table) {
			$table->foreign('payment_schedule_id')->references('id')->on('rf_lease_specifications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_leases', function(Blueprint $table) {
			$table->foreign('lease_escalations_type_id')->references('id')->on('rf_lease_specifications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_lease_escalations', function(Blueprint $table) {
			$table->foreign('rf_lease_id')->references('id')->on('rf_leases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_sub_leases', function(Blueprint $table) {
			$table->foreign('rf_lease_id')->references('id')->on('rf_leases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_lease_unit', function(Blueprint $table) {
			$table->foreign('rf_unit_id')->references('id')->on('rf_units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_lease_unit', function(Blueprint $table) {
			$table->foreign('rf_lease_id')->references('id')->on('rf_leases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_additional_fees_lease', function(Blueprint $table) {
			$table->foreign('rf_lease_id')->references('id')->on('rf_leases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_additional_fees_lease', function(Blueprint $table) {
			$table->foreign('rf_additional_fees')->references('id')->on('rf_additional_fees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_additional_fees_lease', function(Blueprint $table) {
			$table->foreign('calculation_basis_id')->references('id')->on('rf_lease_specifications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_additional_fees_lease', function(Blueprint $table) {
			$table->foreign('payment_frequency_id')->references('id')->on('rf_lease_specifications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_company_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('rf_companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rf_company_user', function(Blueprint $table) {
			$table->foreign('rf_company_id')->references('id')->on('rf_companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('rf_communities', function(Blueprint $table) {
			$table->dropForeign('rf_communities_country_id_foreign');
		});
		Schema::table('rf_communities', function(Blueprint $table) {
			$table->dropForeign('rf_communities_currency_id_foreign');
		});
		Schema::table('rf_communities', function(Blueprint $table) {
			$table->dropForeign('rf_communities_district_id_foreign');
		});
		Schema::table('rf_communities', function(Blueprint $table) {
			$table->dropForeign('rf_communities_city_id_foreign');
		});
		Schema::table('rf_buildings', function(Blueprint $table) {
			$table->dropForeign('rf_buildings_rf_community_id_foreign');
		});
		Schema::table('rf_units', function(Blueprint $table) {
			$table->dropForeign('rf_units_category_id_foreign');
		});
		Schema::table('rf_units', function(Blueprint $table) {
			$table->dropForeign('rf_units_type_id_foreign');
		});
		Schema::table('rf_units', function(Blueprint $table) {
			$table->dropForeign('rf_units_rf_community_id_foreign');
		});
		Schema::table('rf_units', function(Blueprint $table) {
			$table->dropForeign('rf_units_rf_building_id_foreign');
		});
		Schema::table('rf_specifications', function(Blueprint $table) {
			$table->dropForeign('rf_specifications_parent_id_foreign');
		});
		Schema::table('rf_unit_areas', function(Blueprint $table) {
			$table->dropForeign('rf_unit_areas_rf_unit_id_foreign');
		});
		Schema::table('rf_specification_unit', function(Blueprint $table) {
			$table->dropForeign('rf_specification_unit_rf_unit_id_foreign');
		});
		Schema::table('rf_specification_unit', function(Blueprint $table) {
			$table->dropForeign('rf_specification_unit_rf_specification_id_foreign');
		});
		Schema::table('rf_unit_rooms', function(Blueprint $table) {
			$table->dropForeign('rf_unit_rooms_rf_unit_id_foreign');
		});
		Schema::table('rf_unit_marketplaces', function(Blueprint $table) {
			$table->dropForeign('rf_unit_marketplaces_rf_unit_id_foreign');
		});
		Schema::table('rf_leases', function(Blueprint $table) {
			$table->dropForeign('rf_leases_fit_out_status_id_foreign');
		});
		Schema::table('rf_leases', function(Blueprint $table) {
			$table->dropForeign('rf_leases_payment_schedule_id_foreign');
		});
		Schema::table('rf_leases', function(Blueprint $table) {
			$table->dropForeign('rf_leases_lease_escalations_type_id_foreign');
		});
		Schema::table('rf_lease_escalations', function(Blueprint $table) {
			$table->dropForeign('rf_lease_escalations_rf_lease_id_foreign');
		});
		Schema::table('rf_sub_leases', function(Blueprint $table) {
			$table->dropForeign('rf_sub_leases_rf_lease_id_foreign');
		});
		Schema::table('rf_lease_unit', function(Blueprint $table) {
			$table->dropForeign('rf_lease_unit_rf_unit_id_foreign');
		});
		Schema::table('rf_lease_unit', function(Blueprint $table) {
			$table->dropForeign('rf_lease_unit_rf_lease_id_foreign');
		});
		Schema::table('rf_additional_fees_lease', function(Blueprint $table) {
			$table->dropForeign('rf_additional_fees_lease_rf_lease_id_foreign');
		});
		Schema::table('rf_additional_fees_lease', function(Blueprint $table) {
			$table->dropForeign('rf_additional_fees_lease_rf_additional_fees_foreign');
		});
		Schema::table('rf_additional_fees_lease', function(Blueprint $table) {
			$table->dropForeign('rf_additional_fees_lease_calculation_basis_id_foreign');
		});
		Schema::table('rf_additional_fees_lease', function(Blueprint $table) {
			$table->dropForeign('rf_additional_fees_lease_payment_frequency_id_foreign');
		});
		Schema::table('rf_company_user', function(Blueprint $table) {
			$table->dropForeign('rf_company_user_user_id_foreign');
		});
		Schema::table('rf_company_user', function(Blueprint $table) {
			$table->dropForeign('rf_company_user_rf_company_id_foreign');
		});
	}
}