<?php

namespace RFTenant\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RfSubLease extends Eloquent {

	protected $table = 'rf_sub_leases';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('rf_lease_id', 'tenant_type', 'name_ar', 'name_en', 'registration_no', 'tax_identifier_no', 'note');

	public function lease()
	{
		return $this->belongsTo('RFTenant\Models\RfLease');
	}

}