<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoreEmployeeTable extends Migration {

	public function up()
	{
		Schema::create('core_employee', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->char('code', 10);
			$table->string('name');
			$table->enum('id_type', array(''))->nullable();
			$table->string('id_no', 25)->nullable();
			$table->text('home_address')->nullable();
			$table->string('email', 100)->nullable();
			$table->string('tel_no', 20)->nullable();
			$table->string('mobile_no', 20)->nullable();
			$table->date('dob')->nullable();
			$table->char('gender', 1)->default('M');
			$table->string('race', 100);
			$table->string('religion', 100);
			$table->enum('resident_type', array('not-resident', 'resident', 'rep', 'irda'));
			$table->enum('marital_status', array('single.married-spouse-not-working', 'married-spouse-working', 'divorced-widowed'));
			$table->string('nationality', 100);
			$table->boolean('is_disabled')->default(0);
			$table->boolean('is_native')->default(1);
			$table->string('passport_no', 25)->nullable();
			$table->date('passport_expiry')->nullable();
			$table->string('workpass_no', 25)->nullable();
			$table->date('workpass_expiry')->nullable();
			$table->string('health_card_no', 25)->nullable();
			$table->date('health_card_expiry')->nullable();
			$table->string('bank', 100)->nullable();
			$table->string('bank_account_no', 50)->nullable();
			$table->string('ec_name')->nullable();
			$table->string('ec_relationship');
			$table->text('ec_address')->nullable();
			$table->string('ec_contact_no')->nullable();
			$table->string('sp_name')->nullable();
			$table->string('sp_nric', 50)->nullable();
			$table->string('sp_passport_no', 50)->nullable();
			$table->text('sp_address')->nullable();
			$table->string('sp_tax_no', 50)->nullable();
			$table->string('sp_tax_location', 100)->nullable();
			$table->string('sp_nationality', 100)->nullable();
			$table->date('sp_dob')->nullable();
			$table->string('sp_religion')->nullable();
			$table->boolean('sp_is_disabled')->default(0);
			$table->decimal('working_hours', 10,2);
			$table->decimal('working_days', 4,2)->default('26');
			$table->decimal('lunch_hours', 4,2);
			$table->string('locality')->nullable();
			$table->string('branch')->nullable();
			$table->string('department')->nullable();
			$table->string('section')->nullable();
			$table->string('position')->nullable();
			$table->integer('direct_superior')->unsigned()->nullable();
			$table->integer('secondary_superior')->unsigned()->nullable();
			$table->boolean('is_active')->default(1);
			$table->text('remarks')->nullable();
			$table->string('job_type')->nullable();
			$table->string('punch_card_id');
			$table->string('old_id_no');
			$table->string('working_schedule');
			$table->enum('working_type', array(''));
		});
	}

	public function down()
	{
		Schema::drop('core_employee');
	}
}