<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoreEmployeeFamilyTable extends Migration {

	public function up()
	{
		Schema::create('core_employee_family', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('relationship');
			$table->string('contact_no');
			$table->boolean('is_disabled')->default(0);
			$table->date('dob');
			$table->string('marital_status')->nullable();
			$table->string('academic_level');
			$table->integer('employee_id')->unsigned();
			$table->enum('taxrelief_type', array(''));
		});
	}

	public function down()
	{
		Schema::drop('core_employee_family');
	}
}