<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoreSectionTable extends Migration {

	public function up()
	{
		Schema::create('core_section', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->char('code', 10)->unique();
			$table->string('description');
			$table->tinyInteger('active');
			$table->char('key_by', 10);
			$table->char('modified_by', 10);
			$table->datetime('modified_datetime');
			$table->decimal('working_days', 4,2);
			$table->decimal('working_hours', 4,2);
		});
	}

	public function down()
	{
		Schema::drop('core_section');
	}
}