<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLeaveTrnTable extends Migration {

	public function up()
	{
		Schema::create('leave_trn', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->date('apply_date');
			$table->enum('type', array(''));
			$table->char('employee', 10);
			$table->char('leave_type', 10);
			$table->date('date_from');
			$table->tinyInteger('date_from_full');
			$table->enum('date_from_shift', array(''));
			$table->date('date_to');
			$table->tinyInteger('date_to_full');
			$table->enum('date_to_shift', array(''));
			$table->string('reason');
			$table->decimal('total_days', 14,2);
			$table->decimal('medical_claim', 14,2);
			$table->string('approve1_by');
			$table->string('approve1_datetime');
			$table->string('approve1_feedback');
			$table->enum('approve1_action', array(''));
			$table->string('approve2_by');
			$table->datetime('approve2_datetime');
			$table->string('approve2_feedback');
			$table->string('approve2_action');
			$table->string('approve3_by');
			$table->datetime('approve3_datetime');
			$table->string('approve3_feedback');
			$table->enum('approve3_action', array(''));
			$table->enum('status', array(''));
			$table->tinyInteger('bf');
		});
	}

	public function down()
	{
		Schema::drop('leave_trn');
	}
}