<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePayrollEmployeeTaxExemptTable extends Migration {

	public function up()
	{
		Schema::create('payroll_employee_tax_exempt', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->date('term');
			$table->char('employee', 10);
			$table->enum('code', array(''));
			$table->decimal('total', 14,2);
			$table->tinyInteger('payroll');
		});
	}

	public function down()
	{
		Schema::drop('payroll_employee_tax_exempt');
	}
}