<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->string('invoice_number');
			$table->string('title');
			$table->string('description');
			$table->integer('amount');
			$table->integer('order_id')->unsigned();
			$table->integer('user_id');
			$table->integer('pay_id');
			$table->integer('paid');
			$table->integer('create_at');
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}