<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductSaleBillTable extends Migration {

	public function up()
	{
		Schema::create('product_sale_bill', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->bigInteger('sale_bill_id')->unsigned();
			$table->bigInteger('product_id')->unsigned();
			$table->float('price');
			$table->integer('quantity');
			$table->float('discount')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('product_sale_bill');
	}
}