<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('name');
			$table->bigInteger('subcategory_id')->unsigned();
			$table->enum('type', array('consumed', 'sales'));
			$table->boolean('countable');
			$table->float('special_price')->nullable();
			$table->float('price')->nullable();
			$table->integer('number_of_available_pieces')->nullable()->default('0');
			$table->integer('number_of_minimum_pieces')->nullable();
			$table->boolean('about_to_decrease')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}