<?php

namespace App\Models;

class Package extends Eloquent {

	protected $table = 'packages';
	public $timestamps = true;
	protected $fillable = array('resource_id', 'utilization_id', 'accounting_method', 'number_of_paid_hours', 'price');

	public function resource()
	{
		return $this->belongsTo('App\Models\Resource');
	}

	public function utilization()
	{
		return $this->belongsTo('App\Models\Utilization');
	}

	public function sale_bills()
	{
		return $this->hasMany('App\Models\SaleBill');
	}

}