<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('name');
			$table->string('phone')->nullable();
			$table->enum('type', array('employee', 'visitor', 'tenant'));
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}