<?php

namespace App/Model/CourseGoal;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CourseGoal extends Eloquent {

	protected $table = 'course_goals';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('course_id', 'goal', 'status');

	public function courses()
	{
		return $this->belongsToMany('Course', 'course_id');
	}

}