<?php

namespace App\Models\CourseUser;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CourseUser extends Eloquent {

	protected $table = 'course_users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('course_id', 'student_id', 'enroll_date');

	public function courses()
	{
		return $this->belongsToMany('Course', 'course_id');
	}

	public function students()
	{
		return $this->belongsToMany('Student', 'student_id');
	}

}