<?php

namespace App/Model/Download;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Download extends Eloquent {

	protected $table = 'downloads';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'course_id');

	public function course()
	{
		return $this->belongsTo('Course', 'course_id');
	}

}