<?php

namespace App/Model/DownloadAttachement;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DownloadAttachement extends Eloquent {

	protected $table = 'download_attachements';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('download_id', 'title', 'link', 'format', 'status');

	public function downloads()
	{
		return $this->belongsTo('Download', 'dawonload_id');
	}

}