<?php

namespace App/Model/LessonFaq;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class LessonFaq extends Eloquent {

	protected $table = 'lesson_faqs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('lesson_id', 'question', 'answer', 'student_id', 'answerd_by', 'status');

	public function lesson()
	{
		return $this->belongsTo('Lesson', 'lesson_id');
	}

}