<?php

namespace App/Model/LessonReview;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class LessonReviews extends Eloquent {

	protected $table = 'lesson_reviews';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('lesson_id', 'rate', 'comment');

	public function lesson()
	{
		return $this->belongsTo('Lesson', 'lesson_id');
	}

}