<?php

namespace App/Model/StudentLesson;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class StudentLesson extends Eloquent {

	protected $table = 'student_lessons';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('lesson_id', 'student_id', 'start_date', 'status');

	public function lesson()
	{
		return $this->belongsTo('Lesson', 'lesson_id');
	}

	public function student()
	{
		return $this->belongsTo('Student', 'student_id');
	}

}