<?php

namespace App/Model/QuizStudents;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class QuizStudents extends Model 
{

    protected $table = 'quiz_students';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('student_id', 'quiz_id', 'start', 'end', 'degree', 'medal');

    public function student()
    {
        return $this->belongsTo('Student', 'student_id');
    }

    public function quiz()
    {
        return $this->belongsTo('Quiz', 'quiz_id');
    }

}